<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h1, h2, h3 { text-align: center; }
        .header { display: flex; justify-content: space-between; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px; text-align: center; }
        .badge { font-weight: bold; padding: 3px 6px; background: red; color: white; border-radius: 4px;}
    </style>
</head>
<body>

    <h2>📄 Relatório Resumo - Dashboard</h2>
    <p><strong>Data do Relatório:</strong> <?php echo e(now()->format('d/m/Y H:i')); ?></p>

    <h3>Filtros Aplicados</h3>
    <table>
        <tr><td><strong>Início:</strong></td><td><?php echo e(request('start') ?? 'Não definido'); ?></td></tr>
        <tr><td><strong>Fim:</strong></td><td><?php echo e(request('end') ?? 'Não definido'); ?></td></tr>
        <tr><td><strong>Categoria:</strong></td><td><?php echo e(request('categoria') ?? 'Todas'); ?></td></tr>
        <tr><td><strong>Produto:</strong></td><td><?php echo e(request('produto') ?? 'Todos'); ?></td></tr>
        <tr><td><strong>Estoque crítico:</strong></td><td><?php echo e(request('estoque_critico', 5)); ?></td></tr>
    </table>

    <h3>Resumo Financeiro</h3>
    <table>
        <thead>
            <tr>
                <th>Seção</th>
                <th>Total Vendido</th>
                <th>Lucro</th>
                <th>Qtd Estoque</th>
                <th>Valor Estoque</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>BAR</td>
                <td><?php echo e(number_format($barTotalVendido,2,',','.')); ?> MT</td>
                <td><?php echo e(number_format($barLucro,2,',','.')); ?> MT</td>
                <td><?php echo e($barEstoqueQtd); ?></td>
                <td><?php echo e(number_format($barEstoqueValor,2,',','.')); ?> MT</td>
            </tr>
            <tr>
                <td>ARM</td>
                <td><?php echo e(number_format($armTotalVendido,2,',','.')); ?> MT</td>
                <td><?php echo e(number_format($armLucro,2,',','.')); ?> MT</td>
                <td><?php echo e($armEstoqueQtd); ?></td>
                <td><?php echo e(number_format($armEstoqueValor,2,',','.')); ?> MT</td>
            </tr>
            <tr style="background:#eee;">
                <td><strong>TOTAL</strong></td>
                <td><strong><?php echo e(number_format($totalVendas,2,',','.')); ?> MT</strong></td>
                <td><strong><?php echo e(number_format($totalLucro,2,',','.')); ?> MT</strong></td>
                <td><strong><?php echo e($totalEstoqueQtd); ?></strong></td>
                <td><strong><?php echo e(number_format($totalEstoqueValor,2,',','.')); ?> MT</strong></td>
            </tr>
        </tbody>
    </table>

    <h3>🚨 Estoque Crítico</h3>

    <strong>BAR</strong>
    <table>
        <tr><th>Produto</th><th>Quantidade</th></tr>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $criticosBar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr><td><?php echo e($item->nome_pro); ?></td><td class="badge"><?php echo e($item->quant_pro); ?></td></tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr><td colspan="2">Nenhum item crítico</td></tr>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </table>

    <br>

    <strong>ARM</strong>
    <table>
        <tr><th>Produto</th><th>Quantidade</th></tr>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $criticosArm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr><td><?php echo e($item->nome_pro); ?></td><td class="badge"><?php echo e($item->quant_pro); ?></td></tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr><td colspan="2">Nenhum item crítico</td></tr>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </table>

</body>
</html>
<?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/dashboard/report_pdf.blade.php ENDPATH**/ ?>