

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content_header'); ?>
<h1 class="mb-4">Dashboard do Sistema</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Cards modernos */
    .card-modern {
        border-radius: 15px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .card-modern:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.12);
    }

    /* Botões modernos */
    .btn-modern {
        border-radius: 8px;
        padding: 0.5rem 1.2rem;
        font-weight: 600;
        transition: all 0.2s;
    }
    .btn-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }

    /* Inputs modernos */
    .form-control-modern {
        border-radius: 8px;
        border: 1px solid #d1d5db;
        padding: 0.5rem 1rem;
        transition: all 0.3s;
    }
    .form-control-modern:focus {
        outline: none;
        border-color: #0d6efd;
        box-shadow: 0 0 8px rgba(13,110,253,0.2);
    }

    /* Gráficos responsivos */
    .chart-container {
        position: relative;
        height: 300px;
    }

    /* Listas de estoque crítico */
    .list-group-item {
        border-radius: 8px;
        margin-bottom: 5px;
    }
</style>

<div class="container-fluid">

    <!-- Filtros -->
    <form method="GET" action="<?php echo e(route('dashboard')); ?>" class="row mb-4 g-2">
        <div class="col-12 col-md-2">
            <input type="date" name="start" class="form-control-modern w-100" value="<?php echo e(request('start')); ?>">
        </div>
        <div class="col-12 col-md-2">
            <input type="date" name="end" class="form-control-modern w-100" value="<?php echo e(request('end')); ?>">
        </div>
        <div class="col-12 col-md-2">
            <select name="categoria" class="form-control-modern w-100">
                <option value="todas" <?php echo e(request('categoria')=='todas'?'selected':''); ?>>Todos os Setores</option>
                <option value="BAR" <?php echo e(request('categoria')=='BAR'?'selected':''); ?>>BAR</option>
                <option value="ARM" <?php echo e(request('categoria')=='ARM'?'selected':''); ?>>ARM</option>
            </select>
        </div>
        <div class="col-12 col-md-2">
            <select name="produto" class="form-control-modern w-100">
                <option value="todos">Todos os Produtos</option>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $produtosFiltro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($p->codigo_pro); ?>" <?php echo e(request('produto')==$p->codigo_pro?'selected':''); ?>>
                    <?php echo e($p->nome_pro); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </select>
        </div>
        <div class="col-12 col-md-2">
            <input type="number" name="estoque_critico" class="form-control-modern w-100" value="<?php echo e(request('estoque_critico', 5)); ?>" min="1" title="Estoque crítico (<=)">
        </div>
        <div class="col-12 col-md-2 d-grid">
            <button type="submit" class="btn btn-primary btn-modern w-100">Aplicar</button>
        </div>

        <div class="col-12 mt-2 d-flex justify-content-end gap-2">
            <a href="<?php echo e(route('dashboard.export.pdf', request()->all())); ?>" target="_blank" class="btn btn-danger btn-modern">📄 PDF</a>
            <a href="<?php echo e(route('dashboard.export.excel', request()->all())); ?>" class="btn btn-success btn-modern">📎 Excel</a>
        </div>
    </form>

    <!-- CARDS PRINCIPAIS -->
    <div class="row g-3 mb-4">
        <!-- BAR -->
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-info text-white">
                <h6>Vendido (BAR)</h6>
                <h3 class="fw-bold"><?php echo e(number_format($barTotalVendido,2,',','.')); ?> MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-success text-white">
                <h6>Lucro (BAR)</h6>
                <h3 class="fw-bold"><?php echo e(number_format($barLucro,2,',','.')); ?> MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-primary text-white">
                <h6>Qtd Estoque (BAR)</h6>
                <h3 class="fw-bold"><?php echo e($barEstoqueQtd); ?></h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-warning text-dark">
                <h6>Valor Estoque (BAR)</h6>
                <h3 class="fw-bold"><?php echo e(number_format($barEstoqueValor,2,',','.')); ?> MT</h3>
            </div>
        </div>
    </div>

    <!-- ARM -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-info text-white">
                <h6>Vendido (ARM)</h6>
                <h3 class="fw-bold"><?php echo e(number_format($armTotalVendido,2,',','.')); ?> MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-success text-white">
                <h6>Lucro (ARM)</h6>
                <h3 class="fw-bold"><?php echo e(number_format($armLucro,2,',','.')); ?> MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-primary text-white">
                <h6>Qtd Estoque (ARM)</h6>
                <h3 class="fw-bold"><?php echo e($armEstoqueQtd); ?></h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-warning text-dark">
                <h6>Valor Estoque (ARM)</h6>
                <h3 class="fw-bold"><?php echo e(number_format($armEstoqueValor,2,',','.')); ?> MT</h3>
            </div>
        </div>
    </div>

    <!-- TOTAL GERAL -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-info text-white">
                <h6>Total Vendido</h6>
                <h3 class="fw-bold"><?php echo e(number_format($totalVendas,2,',','.')); ?> MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-success text-white">
                <h6>Total Lucro</h6>
                <h3 class="fw-bold"><?php echo e(number_format($totalLucro,2,',','.')); ?> MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-primary text-white">
                <h6>Qtd Estoque Total</h6>
                <h3 class="fw-bold"><?php echo e($totalEstoqueQtd); ?></h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-warning text-dark">
                <h6>Valor Estoque Total</h6>
                <h3 class="fw-bold"><?php echo e(number_format($totalEstoqueValor,2,',','.')); ?> MT</h3>
            </div>
        </div>
    </div>

    <!-- GRÁFICOS -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">📈 Vendas Mensais</h5>
                <div class="chart-container">
                    <canvas id="chartVendas"></canvas>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">💰 Lucro Mensal</h5>
                <div class="chart-container">
                    <canvas id="chartLucro"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- PRODUTOS MAIS VENDIDOS E ESTOQUE CRÍTICO -->
    <div class="row g-3">
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">🔥 Produtos Mais Vendidos</h5>
                <div class="chart-container">
                    <canvas id="chartProdutos"></canvas>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">🚨 Estoque Crítico</h5>

                <h6>BAR</h6>
                <ul class="list-group mb-2">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $criticosBar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo e($item->nome_pro); ?> <span class="badge bg-danger rounded-pill"><?php echo e($item->quant_pro); ?></span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted">Nenhum produto crítico em BAR</li>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>

                <h6>ARM</h6>
                <ul class="list-group">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $criticosArm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo e($item->nome_pro); ?> <span class="badge bg-danger rounded-pill"><?php echo e($item->quant_pro); ?></span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted">Nenhum produto crítico em ARM</li>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const options = { responsive: true, plugins: { legend: { position: 'bottom' } } };

// Gráfico Vendas
new Chart(document.getElementById('chartVendas'), {
    type: 'line',
    data: {
        labels: <?php echo json_encode($vendasMensais->pluck('mes')); ?>,
        datasets: [{
            label: "Vendas (MT)",
            data: <?php echo json_encode($vendasMensais->pluck('total')); ?>,
            borderColor: "#0d6efd",
            backgroundColor: "rgba(13,110,253,0.1)",
            tension: 0.4,
            fill: true,
            pointRadius: 5
        }]
    },
    options: options
});

// Gráfico Lucro
new Chart(document.getElementById('chartLucro'), {
    type: 'bar',
    data: {
        labels: <?php echo json_encode($lucroMensal->pluck('mes')); ?>,
        datasets: [{
            label: "Lucro (MT)",
            data: <?php echo json_encode($lucroMensal->pluck('lucro')); ?>,
            backgroundColor: "#198754",
            borderRadius: 5
        }]
    },
    options: options
});

// Gráfico Produtos Mais Vendidos
new Chart(document.getElementById('chartProdutos'), {
    type: 'doughnut',
    data: {
        labels: <?php echo json_encode($maisVendidos->pluck('nome_pro')); ?>,
        datasets: [{
            data: <?php echo json_encode($maisVendidos->pluck('quant')); ?>,
            backgroundColor: ["#0d6efd","#198754","#ffc107","#dc3545"]
        }]
    },
    options: options
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/dashboard.blade.php ENDPATH**/ ?>