<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Histórico de Entradas de Estoque</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #ddd; }

        .entrada { color: green; font-weight: bold; }
    </style>
</head>
<body>
    <h2> Histórico de Entradas de Estoque</h2>
    <p>Gerado em: <?php echo e(now()->format('d/m/Y H:i')); ?></p>

    <table>
        <thead>
            <tr>
                <th>Data</th>
                <th>Produto</th>
                <th>Quantidade</th>
                <th>Preço Unitário</th>
                <th>Usuário</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $entradas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($e->data)->format('d/m/Y H:i')); ?></td>
                    <td><?php echo e($e->nome_pro); ?> <small>(<?php echo e($e->produto_codigo ?? ''); ?>)</small></td>
                    <td class="entrada"><?php echo e($e->quantidade); ?></td>
                    <td><?php echo e(number_format($e->preco_unitario, 2, ',', '.')); ?> MT</td>
                    <td><?php echo e($e->usuario ?? 'Sistema'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/estoque/entradas_pdf.blade.php ENDPATH**/ ?>