<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Histórico de Movimentos</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #ddd; }

        .entrada { color: green; font-weight: bold; }
        .saida { color: red; font-weight: bold; }
        .ajuste { color: orange; font-weight: bold; }
        .novo_produto { color: blue; font-weight: bold; }
        .atualizacao { color: darkcyan; font-weight: bold; }
        .remocao { color: darkred; font-weight: bold; }
    </style>
</head>
<body>
    <h2>📦 Histórico de Movimentações do Estoque</h2>
    <p>Gerado em: <?php echo e(now()->format('d/m/Y H:i')); ?></p>

    <table>
        <thead>
            <tr>
                <th>Data</th>
                <th>Produto</th>
                <th>Tipo</th>
                <th>Quantidade</th>
                <th>Custo</th>
                <th>Referência</th>
                <th>Usuário</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $movimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($m->created_at)->format('d/m/Y H:i')); ?></td>
                    <td><?php echo e($m->nome_pro); ?> <small>(<?php echo e($m->produto_codigo); ?>)</small></td>
                    <td class="<?php echo e($m->tipo); ?>">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($m->tipo):
                            case ('entrada'): ?> Entrada <?php break; ?>
                            <?php case ('saida'): ?> Saída <?php break; ?>
                            <?php case ('ajuste'): ?> Ajuste <?php break; ?>
                            <?php case ('novo_produto'): ?> Novo Produto <?php break; ?>
                            <?php case ('atualizacao'): ?> Atualização <?php break; ?>
                            <?php case ('remocao'): ?> Remoção <?php break; ?>
                            <?php default: ?> — <?php break; ?>
                        <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </td>
                    <td><?php echo e($m->quantidade); ?></td>
                    <td><?php echo e(number_format($m->custo_unitario,2,',','.')); ?></td>
                    <td><?php echo e($m->referencia ?? '—'); ?></td>
                    <td><?php echo e($m->usuario_nome ?? '—'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/estoque/historico_pdf.blade.php ENDPATH**/ ?>