

<?php $__env->startSection('title', 'Histórico de Movimentos'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Histórico de Movimentação do Estoque</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<form method="GET" class="row mb-4 g-2">

    <div class="col-md-3">
        <label>Produto</label>
        <input type="text" name="produto" value="<?php echo e(request('produto')); ?>" class="form-control rounded-input" placeholder="Nome ou Código">
    </div>

    <div class="col-md-3">
        <label>Data Início</label>
        <input type="date" name="inicio" value="<?php echo e(request('inicio')); ?>" class="form-control rounded-input">
    </div>

    <div class="col-md-3">
        <label>Data Fim</label>
        <input type="date" name="fim" value="<?php echo e(request('fim')); ?>" class="form-control rounded-input">
    </div>

    <div class="col-md-3 d-flex align-items-end gap-2">
        <button class="btn btn-primary btn-modern w-100">🔍 Filtrar</button>
        <a href="<?php echo e(route('estoque.historico')); ?>" class="btn btn-secondary btn-modern w-100">↺ Limpar</a>
    </div>
</form>


<div class="card shadow-sm rounded">
    <div class="card-header d-flex justify-content-between align-items-center bg-dark text-white">
        <strong>Registros</strong>
        <a href="<?php echo e(route('estoque.historico.pdf', request()->all())); ?>" class="btn btn-danger btn-sm btn-modern">
            📄 Exportar PDF
        </a>
    </div>

    <div class="card-body p-0 table-responsive">
        <table class="table table-striped table-hover mb-0">
            <thead class="table-dark">
                <tr>
                    <th>Data</th>
                    <th>Produto</th>
                    <th>Tipo</th>
                    <th>Quantidade</th>
                    <th>P.Compra</th>
                    <th>Total</th>
                    <th>Referência</th>
                    <th>Usuário</th>
                </tr>
            </thead>
            <tbody>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $movimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e(date('d/m/Y H:i', strtotime($m->created_at))); ?></td>
                        <td><?php echo e($m->nome_pro); ?> <small class="text-muted">(<?php echo e($m->produto_codigo); ?>)</small></td>

                        
                        <td>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($m->tipo):
                                case ('entrada'): ?>
                                    <span class="badge bg-success">⬆ Entrada</span>
                                <?php break; ?>
                                <?php case ('saida'): ?>
                                    <span class="badge bg-danger">⬇ Saída</span>
                                <?php break; ?>
                                <?php case ('ajuste'): ?>
                                    <span class="badge bg-warning text-dark">⚠ Ajuste</span>
                                <?php break; ?>
                                <?php case ('novo_produto'): ?>
                                    <span class="badge bg-info text-dark">🆕 Novo Produto</span>
                                <?php break; ?>
                                <?php case ('atualizacao'): ?>
                                    <span class="badge bg-primary text-light">✏ Atualização</span>
                                <?php break; ?>
                                <?php case ('remocao'): ?>
                                    <span class="badge bg-danger text-light">❌ Remoção</span>
                                <?php break; ?>
                                <?php default: ?>
                                    <span class="badge bg-secondary">—</span>
                            <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </td>

                        <td><?php echo e($m->quantidade); ?></td>
                        <td><?php echo e(number_format($m->custo_unitario, 2)); ?> MT</td>
                        <td><?php echo e(number_format($m->quantidade * $m->custo_unitario, 2)); ?> MT</td>
                        <td><?php echo e($m->referencia ?? '—'); ?></td>
                        <td><?php echo e($m->usuario_nome ?? '—'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted">Nenhum registro encontrado.</td>
                    </tr>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </tbody>
        </table>

        
        <div class="mt-3 px-3">
            <?php echo e($movimentos->links()); ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<style>
    /* Inputs arredondados */
    .rounded-input {
        border-radius: 8px;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    .rounded-input:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 8px rgba(59, 130, 246, 0.4);
    }

    /* Botões modernos */
    .btn-modern {
        border-radius: 8px;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    .btn-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.25);
    }

    /* Badges mais visuais */
    .badge {
        font-size: 0.85rem;
        padding: 0.35em 0.65em;
        border-radius: 6px;
    }

    /* Card da tabela */
    .card.shadow-sm {
        border-radius: 10px;
        overflow: hidden;
    }

    /* Linha da tabela com hover */
    table.table-striped tbody tr:hover {
        background-color: #f1f5f9;
    }

    @media (max-width:576px){
        .table-responsive { overflow-x:auto; }
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/estoque/historico.blade.php ENDPATH**/ ?>