

<?php $__env->startSection('title', 'Produtos'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Estoque de Produtos</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php
    $usuario = Auth::user();
?>

<div class="mb-3 d-flex justify-content-between align-items-center">
    <button class="btn btn-primary btn-modern btn-new">
        Novo Produto
    </button>
</div>

<!-- Modal Cadastrar / Editar Produto -->
<div class="modal fade" 
     id="productModal" 
     tabindex="-1" 
     aria-labelledby="productModalLabel" 
     aria-hidden="true"
     data-bs-backdrop="static" 
     data-bs-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="productModalLabel">Cadastrar Novo Produto</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <form id="formCadastrarProduto" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row g-2">
                        <div class="col-md-4">
                            <label>Código</label>
                            <input type="text" name="codigo_pro" id="codigo_pro" class="form-control" readonly>
                        </div>

                        <div class="col-md-4">
                            <label>Tipo</label>
                            <select name="tipo_pro" id="tipo_pro" class="form-control" required>
                                <option value="">-- Selecione --</option>
                                <option value="BEBIDAS">BEBIDAS</option>
                                <option value="REGRIGERANTE">REGRIGERANTE</option>
                                <option value="REFEICAO">REFEIÇÃO</option>
                                <option value="REFEICAO">PETISCO</option>
                                <option value="REFEICAO">SOPA</option>
                                <option value="SUMO">SUMO</option>
                                <option value="ENERGETICO">ENERGÉTICO</option>
                                <option value="OUTROS">OUTROS</option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label>Nome</label>
                            <input type="text" name="nome_pro" class="form-control" placeholder="Digite o nome do produto" required>
                        </div>

                        <div class="col-md-4 mt-2">
                            <label>P. Venda</label>
                            <input type="number" step="0.01" name="valor_pro" class="form-control" placeholder="Preço de venda" required>
                        </div>

                        <div class="col-md-4 mt-2">
                            <label>P. Compra</label>
                            <input type="number" step="0.01" name="valor_compra" class="form-control" placeholder="Preço de compra" required>
                        </div>

                        <div class="col-md-4 mt-2">
                            <label>Quantidade</label>
                            <input type="number" name="quant_pro" class="form-control" placeholder="Quantidade em estoque" required>
                        </div>

                        <div class="col-md-4 mt-2">
                            <label>Data</label>
                            <input type="date" name="data_pro" class="form-control" required>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($usuario->tipo_us === 'ADMIN'): ?>
                        <div class="col-md-4 mt-2">
                            <label>Acesso</label>
                            <select name="acesso_pro" class="form-control" required>
                                <option value="">-- Selecione --</option>
                                <option value="BAR">BAR</option>
                                <option value="ARM">ARM</option>
                            </select>
                        </div>
                        <?php else: ?>
                            <input type="hidden" name="acesso_pro" value="<?php echo e($usuario->acesso_us); ?>">
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="modal-footer mt-3">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success btn-save">Salvar</button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<!-- Tabela de Produtos -->
<div class="table-responsive">
    <table class="table table-bordered table-striped datatable nowrap" style="width:100%">
        <thead class="table-dark">
            <tr>
                <th>Código</th>
                <th>Tipo</th>
                <th>Nome</th>
                <th>P.Venda</th>
                <th>P.Compra</th>
                <th>Qtd</th>
                <!--<th>T.Venda</th>-->
                <!--<th>T.Compra</th>-->
                <!--<th>Lucro</th>-->
                <th>Data</th>
                <th style="width:120px">Ações</th>
            </tr>
        </thead>
        <tbody>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($produto->codigo_pro); ?></td>
                <td><?php echo e($produto->tipo_pro); ?></td>
                <td><?php echo e($produto->nome_pro); ?></td>
                <td><?php echo e(number_format($produto->valor_pro,2,',','.')); ?> MT</td>
                <td><?php echo e(number_format($produto->valor_compra,2,',','.')); ?> MT</td>
                <td><?php echo e($produto->quant_pro); ?></td>
                <!--<td><?php echo e(number_format($produto->subtotalvenda,2,',','.')); ?> MT</td>-->
                <!--<td><?php echo e(number_format($produto->subtotalcompra,2,',','.')); ?> MT</td>-->
                <!--<td><?php echo e(number_format($produto->subtotallucro,2,',','.')); ?> MT</td>-->
                <td><?php echo e($produto->data_pro); ?></td>
                <td>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($usuario->tipo_us === 'ADMIN'): ?>
                        <button class="btn btn-warning btn-sm btn-edit"
                            data-codigo="<?php echo e($produto->codigo_pro); ?>"
                            data-tipo="<?php echo e($produto->tipo_pro); ?>"
                            data-nome="<?php echo e($produto->nome_pro); ?>"
                            data-venda="<?php echo e($produto->valor_pro); ?>"
                            data-compra="<?php echo e($produto->valor_compra); ?>"
                            data-quantidade="<?php echo e($produto->quant_pro); ?>"
                            data-data="<?php echo e($produto->data_pro); ?>">
                            Editar
                        </button>
                        <button class="btn btn-danger btn-sm btn-delete" data-id="<?php echo e($produto->codigo_pro); ?>">
                            Apagar
                        </button>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

<style>
    /* Botão principal com hover suave */
    .btn-modern {
        border-radius: 8px;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
    }
    .btn-modern:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.25);
    }

    /* Cabeçalho do modal e tabela */
    .modal-header.bg-primary {
        background-color: #121212 !important;
        color: white !important;
        font-weight: 700;
        border-bottom: none;
    }
    table.table-dark {
        background-color: #121212 !important;
        color: #fff !important;
        font-weight: 600;
    }

    /* Inputs modernos */
    .form-control {
        border-radius: 8px;
        transition: border-color 0.3s ease;
    }
    .form-control:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 8px rgba(59, 130, 246, 0.4);
    }

    /* Tabela com linhas levemente elevadas */
    table.table-bordered tbody tr {
        background: #fff;
        box-shadow: 0 1px 5px rgba(0,0,0,0.07);
        border-radius: 8px;
        margin-bottom: 10px;
    }

    /* Botões editar/apagar suaves */
    .btn-warning, .btn-danger {
        border-radius: 6px;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }
    .btn-warning:hover { background-color: #d97706; }
    .btn-danger:hover { background-color: #b91c1c; }

    @media (max-width: 576px) {
        .dataTables_wrapper { overflow-x: auto; }
        table.table-bordered { font-size: 0.9rem; }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script>
$(document).ready(function () {

    // DATATABLE
    const table = $('.datatable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', exportOptions: { columns: [0,1,2,3,5,6,9] } },
            { extend: 'csv', exportOptions: { columns: [0,1,2,3,5,6,9] } },
            { extend: 'excel', exportOptions: { columns: [0,1,2,3,5,6,9] } },
            { extend: 'pdf', exportOptions: { columns: [0,1,2,3,5,6,9] } },
            { extend: 'print', exportOptions: { columns: [0,1,2,3,5,6,9] } }
        ],
        language: { url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/pt-PT.json" }
    });

    // NOVO PRODUTO
    $(document).on('click', '.btn-new', function () {
        $('#formCadastrarProduto')[0].reset();
        $('#productModalLabel').text('Cadastrar Novo Produto');
        $('.btn-save').text('Cadastrar');
        $('#formCadastrarProduto input[name="_method"]').remove();
        $('#formCadastrarProduto').attr('action', "<?php echo e(route('produtos.store')); ?>");

        $.get("<?php echo e(route('produtos.nextCode')); ?>", function(response){
            $('#codigo_pro').val(response.next);
        });

        $('#productModal').modal('show');
    });

    // EDITAR PRODUTO
    $(document).on('click', '.btn-edit', function () {
        const btn = $(this);
        $('#productModalLabel').text('Editar Produto');
        $('.btn-save').text('Atualizar');
        $('#formCadastrarProduto')[0].reset();

        $('#codigo_pro').val(btn.data('codigo'));
        $('#tipo_pro').val(btn.data('tipo'));
        $('input[name="nome_pro"]').val(btn.data('nome'));
        $('input[name="valor_pro"]').val(btn.data('venda'));
        $('input[name="valor_compra"]').val(btn.data('compra'));
        $('input[name="quant_pro"]').val(btn.data('quantidade'));
        $('input[name="data_pro"]').val(btn.data('data'));

        let updateUrl = "<?php echo e(route('produtos.update', ':codigo')); ?>".replace(':codigo', btn.data('codigo'));
        $('#formCadastrarProduto').attr('action', updateUrl);
        $('#formCadastrarProduto input[name="_method"]').remove();
        $('#formCadastrarProduto').append('<input type="hidden" name="_method" value="PUT">');

        $('#productModal').modal('show');
    });

    // SALVAR CADASTRO / EDIÇÃO (AJAX)
    $('#formCadastrarProduto').submit(function (e) {
        e.preventDefault();
        let btn = $('.btn-save');
        let txt = btn.text();
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Aguarde...');

        $.ajax({
            url: $(this).attr('action'),
            type: "POST",
            data: $(this).serialize(),
            success: function () {
                $('#productModal').modal('hide');
                Swal.fire('Sucesso!', 'Operação realizada com sucesso!', 'success');
                setTimeout(() => location.reload(), 500);
            },
            error: function (xhr) {
                console.log(xhr.responseText);
                Swal.fire('Erro!', 'Falha ao processar.', 'error');
                btn.prop('disabled', false).text(txt);
            }
        });
    });

    // EXCLUIR PRODUTO
    $(document).on('click', '.btn-delete', function () {
        let codigo = $(this).data('id');
        let row = $(this).closest('tr');

        Swal.fire({
            title: 'Apagar produto?',
            text: "Esta ação não pode ser desfeita!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sim, apagar!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (!result.isConfirmed) return;

            let url = "<?php echo e(route('produtos.destroy', ':codigo')); ?>".replace(':codigo', codigo);

            $.ajax({
                url: url,
                type: 'DELETE',
                data: { _token: '<?php echo e(csrf_token()); ?>' },
                success: function () {
                    row.fadeOut(300, function () { $(this).remove(); });
                    Swal.fire('Removido!', 'Produto deletado.', 'success');
                },
                error: function () {
                    Swal.fire('Erro!', 'Não foi possível remover.', 'error');
                }
            });
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/produtos/index.blade.php ENDPATH**/ ?>