

<?php $__env->startSection('title', 'Usuários'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Gestão de Usuários</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="mb-3 d-flex justify-content-between align-items-center">
    <button class="btn btn-primary btn-modern btn-new">
        Novo Usuário
    </button>
</div>

<!-- Modal Cadastrar / Editar Usuário -->
    <div class="modal fade" 
     id="usuarioModal" 
     tabindex="-1" 
     aria-labelledby="usuarioModalLabel" 
     aria-hidden="true"
     data-bs-backdrop="static" 
     data-bs-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="usuarioModalLabel">Cadastrar Novo Usuário</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <form id="formCadastrarUsuario" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row g-2">
                        <div class="col-md-3">
                            <label>Código</label>
                            <input type="text" name="codigo_us" id="codigo_us" class="form-control" readonly>
                        </div>

                        <div class="col-md-3">
                            <label>Tipo</label>
                            <select name="tipo_us" id="tipo_us" class="form-control" required>
                                <option value="">-- Selecione --</option>
                                <option value="ADMIN">ADMIN</option>
                                <option value="NORMAL">NORMAL</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label>Acesso</label>
                            <select name="acesso_us" id="acesso_us" class="form-control" required>
                                <option value="">-- Selecione --</option>
                                <option value="BAR">BAR</option>
                                <option value="ARM">ARM</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label>Sexo</label>
                            <select name="sexo_us" class="form-control" required>
                                <option value="">-- Selecione --</option>
                                <option value="M">M</option>
                                <option value="F">F</option>
                            </select>
                        </div>

                        <div class="col-md-6 mt-2">
                            <label>Nome</label>
                            <input type="text" name="nome_us" class="form-control" required>
                        </div>

                        <div class="col-md-6 mt-2">
                            <label>Senha</label>
                            <input type="password" name="senha" class="form-control" required>
                        </div>
                    </div>

                    <div class="modal-footer mt-3">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success btn-save">Salvar</button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<!-- Tabela de Usuários -->
<div class="table-responsive">
    <table class="table table-bordered table-striped datatable nowrap" style="width:100%">
        <thead class="table-dark">
            <tr>
                <th>Código</th>
                <th>Nome</th>
                <th>Sexo</th>
                <th>Tipo</th>
                <th>Acesso</th>
                <th style="width:120px">Ações</th>
            </tr>
        </thead>
        <tbody>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($usuario->codigo_us); ?></td>
                <td><?php echo e($usuario->nome_us); ?></td>
                <td><?php echo e($usuario->sexo_us); ?></td>
                <td><?php echo e($usuario->tipo_us); ?></td>
                <td><?php echo e($usuario->acesso_us); ?></td>
                <td>
                    <button class="btn btn-warning btn-sm btn-edit"
                        data-codigo="<?php echo e($usuario->codigo_us); ?>"
                        data-nome="<?php echo e($usuario->nome_us); ?>"
                        data-sexo="<?php echo e($usuario->sexo_us); ?>"
                        data-tipo="<?php echo e($usuario->tipo_us); ?>"
                        data-acesso="<?php echo e($usuario->acesso_us); ?>">
                        Editar
                    </button>
                    <button class="btn btn-danger btn-sm btn-delete" data-id="<?php echo e($usuario->codigo_us); ?>">
                        Apagar
                    </button>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

<style>
    /* Botões modernos */
    .btn-modern {
        border-radius: 8px;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    .btn-modern:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.25);
    }

    /* Modal e tabela */
    .modal-header.bg-primary {
        background-color: #121212 !important;
        color: white !important;
        font-weight: 700;
        border-bottom: none;
    }
    table.table-dark {
        background-color: #121212 !important;
        color: #fff !important;
        font-weight: 600;
    }

    /* Inputs modernos */
    .form-control {
        border-radius: 8px;
        transition: border-color 0.3s ease;
    }
    .form-control:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 8px rgba(59, 130, 246, 0.4);
    }

    /* Linhas da tabela */
    table.table-bordered tbody tr {
        background: #fff;
        box-shadow: 0 1px 5px rgba(0,0,0,0.07);
        border-radius: 8px;
        margin-bottom: 10px;
    }

    /* Botões ação */
    .btn-warning, .btn-danger {
        border-radius: 6px;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }
    .btn-warning:hover { background-color: #d97706; }
    .btn-danger:hover { background-color: #b91c1c; }

    @media (max-width:576px){
        .dataTables_wrapper { overflow-x:auto; }
        table.table-bordered { font-size:0.9rem; }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {

    const table = $('.datatable').DataTable({
        responsive:true,
        scrollX:true,
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', exportOptions: { columns: [0,1,2,3,4] } },
            { extend: 'csv', exportOptions: { columns: [0,1,2,3,4] } },
            { extend: 'excel', exportOptions: { columns: [0,1,2,3,4] } },
            { extend: 'pdf', exportOptions: { columns: [0,1,2,3,4] } },
            { extend: 'print', exportOptions: { columns: [0,1,2,3,4] } }
        ],
        language: { url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/pt-PT.json" }
    });

    // NOVO USUÁRIO
    $(document).on('click', '.btn-new', function() {
        $('#formCadastrarUsuario')[0].reset();
        $('#usuarioModalLabel').text('Cadastrar Novo Usuário');
        $('.btn-save').text('Salvar');
        $('#formCadastrarUsuario').attr('action', "<?php echo e(route('usuarios.store')); ?>");

        $.get("<?php echo e(route('usuarios.nextCode')); ?>", function(response){
            $('#codigo_us').val(response.next);
        });

        $('#usuarioModal').modal('show');
    });

    // EDITAR USUÁRIO
    $(document).on('click', '.btn-edit', function() {
        $('#formCadastrarUsuario')[0].reset();
        $('#usuarioModalLabel').text('Editar Usuário');
        $('.btn-save').text('Atualizar');

        $('#codigo_us').val($(this).data('codigo'));
        $('input[name="nome_us"]').val($(this).data('nome'));
        $('select[name="sexo_us"]').val($(this).data('sexo'));
        $('select[name="tipo_us"]').val($(this).data('tipo'));
        $('select[name="acesso_us"]').val($(this).data('acesso'));
        $('input[name="senha"]').val('');

        let updateUrl = "<?php echo e(route('usuarios.update', ':codigo')); ?>".replace(':codigo', $(this).data('codigo'));
        $('#formCadastrarUsuario').attr('action', updateUrl);
        $('#formCadastrarUsuario input[name="_method"]').remove();
        $('#formCadastrarUsuario').append('<input type="hidden" name="_method" value="PUT">');

        $('#usuarioModal').modal('show');
    });

    // SALVAR / ATUALIZAR AJAX
    $('#formCadastrarUsuario').submit(function(e) {
        e.preventDefault();
        let btn = $('.btn-save');
        let txt = btn.text();
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Aguarde...');

        $.ajax({
            url: $(this).attr('action'),
            type: "POST",
            data: $(this).serialize(),
            success: function() {
                $('#usuarioModal').modal('hide');
                Swal.fire('Sucesso!', 'Operação realizada com sucesso.', 'success');
                setTimeout(() => location.reload(), 500);
            },
            error: function(xhr) {
                console.log(xhr.responseText);
                Swal.fire('Erro!', 'Falha ao processar.', 'error');
                btn.prop('disabled', false).text(txt);
            }
        });
    });

    // DELETAR USUÁRIO
    $(document).on('click', '.btn-delete', function() {
        let codigo = $(this).data('id');
        let row = $(this).closest('tr');

        Swal.fire({
            title: 'Apagar usuário?',
            text: "Esta ação não pode ser desfeita!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sim, apagar!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (!result.isConfirmed) return;

            let url = "<?php echo e(route('usuarios.destroy', ':codigo')); ?>".replace(':codigo', codigo);

            $.ajax({
                url: url,
                type: 'DELETE',
                data: { _token: '<?php echo e(csrf_token()); ?>' },
                success: function() {
                    row.fadeOut(300, function() { $(this).remove(); });
                    Swal.fire('Removido!', 'Usuário deletado.', 'success');
                },
                error: function() {
                    Swal.fire('Erro!', 'Não foi possível remover.', 'error');
                }
            });
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/usuarios/index.blade.php ENDPATH**/ ?>