<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - NaChurasqueira</title>
    <link rel="stylesheet" href="<?php echo e(asset('vendor/adminlte/dist/css/adminlte.min.css')); ?>">
    <style>
        /* Reset visual e centralização */
        body, html {
            height: 100%;
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Caixa de login */
        .login-box {
            width: 100%;
            max-width: 380px;
            background: #fff;
            padding: 40px 30px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        /* .login-logo {
            font-size: 2rem;
            font-weight: 600;
            text-align: center;
            margin-bottom: 25px;
            color: #333;
        } */
                
        .login-logo {
            font-size: 2rem;
            font-weight: bold;
            text-align: center;
            margin-bottom: 20px;
            color: #0078d7; /* Azul estilo Microsoft */
        }

        /* Inputs modernos */
        .input-group {
            position: relative;
            margin-bottom: 25px;
        }

        .input-group input {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .input-group input:focus {
            border-color: #0078D4; /* Azul Microsoft */
            outline: none;
            box-shadow: 0 0 5px rgba(0,120,212,0.3);
        }

        /* Placeholder flutuante estilo Google */
        .input-group label {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #aaa;
            font-size: 0.9rem;
            pointer-events: none;
            transition: 0.3s ease all;
        }

        .input-group input:focus + label,
        .input-group input:not(:placeholder-shown) + label {
            top: -8px;
            left: 10px;
            font-size: 0.75rem;
            color: #0078D4;
            background: #fff;
            padding: 0 4px;
        }

        /* Botão moderno */
        .btn-login {
            width: 100%;
            padding: 12px;
            font-size: 1rem;
            background-color: #0078D4;
            border: none;
            border-radius: 6px;
            color: #fff;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .btn-login:hover {
            background-color: #005a9e;
        }

        /* Alertas */
        .alert {
            padding: 10px;
            border-radius: 6px;
            font-size: 0.9rem;
            margin-bottom: 20px;
        }

        .alert-danger {
            background-color: #fdecea;
            color: #b71c1c;
        }

        @media (max-width: 400px) {
            .login-box {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>

<div class="login-box">
    <div class="login-logo">
        Na<b>Churrasqueira</b>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('fail')): ?>
        <div class="alert alert-danger"><?php echo e(session('fail')); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <form action="<?php echo e(route('login.submit')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="input-group">
            <input type="text" name="usuario" id="usuario" placeholder=" " required>
            <label for="usuario">Usuário</label>
        </div>

        <div class="input-group">
            <input type="password" name="senha" id="senha" placeholder=" " required>
            <label for="senha">Senha</label>
        </div>

        <button type="submit" class="btn-login">Entrar</button>
    </form>
</div>

</body>
</html>
<?php /**PATH /home/churasqu/public_html/admin-panel/resources/views/login.blade.php ENDPATH**/ ?>