<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProdutoController;
use App\Http\Controllers\VendaController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CaixaController;
use App\Http\Controllers\EntradaEstoqueController;
use App\Http\Controllers\EstoqueController;
use App\Http\Controllers\PedidoController;
use App\Http\Controllers\UsuarioController;
use App\Livewire\TesteLivewire;

/*
|--------------------------------------------------------------------------
| 🔐 Rotas de Autenticação
|--------------------------------------------------------------------------
*/
Route::get('/login', [AuthController::class, 'loginPage'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::middleware('authcheck')->group(function () {

    /*
    |--------------------------------------------------------------------------
    | Dashboard
    |--------------------------------------------------------------------------
    */
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::prefix('dashboard')->group(function () {
        Route::get('/export/pdf', [DashboardController::class, 'exportPdf'])->name('dashboard.export.pdf');
        Route::get('/export/excel', [DashboardController::class, 'exportExcel'])->name('dashboard.export.excel');
        Route::get('/data', [DashboardController::class, 'ajaxData'])->name('dashboard.data');
    });

    /*
    |--------------------------------------------------------------------------
    | Usuários
    |--------------------------------------------------------------------------
    */
    Route::prefix('usuarios')->group(function () {
        Route::get('/', [UsuarioController::class, 'index'])->name('usuarios.index');
        Route::get('/next-code', [UsuarioController::class, 'nextCode'])->name('usuarios.nextCode');
        Route::post('/', [UsuarioController::class, 'store'])->name('usuarios.store');
        Route::put('/{codigo_us}', [UsuarioController::class, 'update'])->name('usuarios.update');
        Route::delete('/{codigo_us}', [UsuarioController::class, 'destroy'])->name('usuarios.destroy');
    });

    /*
    |--------------------------------------------------------------------------
    | Produtos
    |--------------------------------------------------------------------------
    */
    Route::get('/produtos/proximo-codigo', [ProdutoController::class, 'nextCode'])->name('produtos.nextCode');
    Route::resource('produtos', ProdutoController::class);

    /*
    |--------------------------------------------------------------------------
    | Caixa
    |--------------------------------------------------------------------------
    */
    Route::prefix('caixa')->group(function () {
        Route::get('/', [CaixaController::class, 'index'])->name('caixa.index');
        Route::get('/produto/busca', [CaixaController::class, 'searchProduct'])->name('caixa.searchProduct');
        Route::get('/produto/estoque/{codigo}', [CaixaController::class, 'checarEstoque'])->name('produto.checarEstoque');
        Route::post('/finalizar', [CaixaController::class, 'finalizarVenda'])->name('caixa.finalizarVenda');
    });

    /*
    |--------------------------------------------------------------------------
    | Entradas de Estoque
    |--------------------------------------------------------------------------
    */
    Route::prefix('estoque')->group(function () {
        Route::get('/estoque', [EntradaEstoqueController::class, 'index'])->name('estoque.entradas');

        Route::get('/', [EntradaEstoqueController::class, 'index'])->name('estoque.index');
        Route::post('/', [EntradaEstoqueController::class, 'store'])->name('estoque.store');
        Route::delete('/{id}', [EntradaEstoqueController::class, 'destroy'])->name('estoque.destroy');
        Route::get('/produtos/buscar', [EntradaEstoqueController::class, 'buscarProduto'])->name('estoque.buscarProduto');
        Route::get('/exportar/pdf', [EntradaEstoqueController::class, 'exportarPDF'])->name('estoque.exportarPDF');
    });

    /*
    |--------------------------------------------------------------------------
    | Rotas apenas para ADMIN
    |--------------------------------------------------------------------------
    */
    Route::middleware('role:ADMIN')->group(function () {

        // Vendas
        Route::prefix('vendas')->group(function () {
            Route::get('/', [VendaController::class, 'index'])->name('vendas.index');
            Route::get('/{codigo}', [VendaController::class, 'detalhes'])->name('vendas.detalhes');
            Route::get('/{codigo}/pdf', [VendaController::class, 'exportarPDF'])->name('vendas.pdf');
        });

        // Histórico de Movimentos de Estoque
        Route::get('/estoque/historico', [EstoqueController::class, 'historico'])->name('estoque.historico');
        Route::get('/estoque/historico/pdf', [EstoqueController::class, 'exportarPDF'])->name('estoque.historico.pdf');

        // Pedidos
        Route::resource('pedidos', PedidoController::class);
        Route::post('/pedidos/{id}/adicionar-item', [PedidoController::class, 'adicionarItem'])->name('pedidos.addItem');
        Route::post('/pedido-item/{item}/pagar', [PedidoController::class, 'pagarItem'])->name('pedidos.pagarItem');
        Route::post('/pedido/{id}/finalizar', [PedidoController::class, 'finalizar'])->name('pedido.finalizar');

    });

});
