<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Relatório de Venda</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #ddd; }
        h2, h3 { margin: 0; padding: 0; }
        h3 { text-align: right; margin-top: 15px; }
        .metodo_pagamento { font-weight: bold; }
    </style>
</head>
<body>
    <h2>📄 Relatório da Venda</h2>
    <p><strong>Código:</strong> {{ $venda->codigo }}</p>
    <p><strong>Usuário:</strong> {{ $venda->usuario }}</p>
    <p><strong>Data:</strong> {{ \Carbon\Carbon::parse($venda->data)->format('d/m/Y H:i') }}</p>
    <p><strong>Método de Pagamento:</strong> <span class="metodo_pagamento">{{ $venda->metodo_pagamento ?? '—' }}</span></p>
    <p><strong>Valor Recebido:</strong> {{ number_format($venda->valor_recebido ?? 0, 2, ',', '.') }} MT</p>
    <p><strong>Troco:</strong> {{ number_format($venda->troco ?? 0, 2, ',', '.') }} MT</p>
    <p><strong>Referência:</strong> {{ $venda->referencia ?? '—' }}</p>

    <table>
        <thead>
            <tr>
                <th>Produto</th>
                <th>Preço Unitário</th>
                <th>Quantidade</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($itens as $i)
            <tr>
                <td>{{ $i->nome_pro }}</td>
                <td>{{ number_format($i->preco, 2, ',', '.') }} MT</td>
                <td>{{ $i->quantidade }}</td>
                <td>{{ number_format($i->subtotal, 2, ',', '.') }} MT</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <h3>Total Geral: {{ number_format($total, 2, ',', '.') }} MT</h3>
</body>
</html>
