@extends('adminlte::page')

@section('title', 'Vendas')

@section('content_header')
    <h1 class="fw-bold">Histórico de Vendas</h1>
@stop

@section('content')
<div class="row mb-3">
    <div class="col-md-3 mb-2">
        <label class="form-label">Data Inicial</label>
        <input type="date" id="data_inicio" class="form-control">
    </div>

    <div class="col-md-3 mb-2">
        <label class="form-label">Data Final</label>
        <input type="date" id="data_fim" class="form-control">
    </div>

    <div class="col-md-3 mb-2">
        <label>&nbsp;</label>
        <button class="btn btn-primary w-100 btn-filter">Filtrar</button>
    </div>

    <div class="col-md-3 mb-2">
        <label>&nbsp;</label>
        <button class="btn btn-secondary w-100 btn-reset">Limpar Filtros</button>
    </div>
</div>

<table class="table table-striped table-hover table-bordered align-middle datatable-vendas" style="width:100%;">
    <thead class="table-dark">
        <tr>
            <th>Código</th>
            <th>Usuário</th>
            <th>N° Itens</th>
            <th>Total Pago</th>
            <th>Data</th>
            <th>Ações</th>
        </tr>
    </thead>
    <tbody>
        @foreach($vendas as $v)
        <tr>
            <td data-label="Código">{{ $v->codigo }}</td>
            <td data-label="Usuário">{{ $v->usuario }}</td>
            <td data-label="N° Itens">{{ $v->nr_itens }}</td>
            <td data-label="Total Pago">{{ $v->valorPago }}</td>
            <td data-label="Data">{{ $v->data }}</td>
            <td data-label="Ações">
                <button class="btn btn-info btn-sm btn-details" data-id="{{ $v->codigo }}">
                    Ver Detalhes
                </button>
            </td>
        </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <th colspan="2" class="text-end">Totais:</th>
            <th id="totalItens"></th>
            <th id="totalValor"></th>
            <th colspan="2"></th>
        </tr>
    </tfoot>
</table>

<!-- Modal Detalhes -->
<div class="modal fade" id="detalhesModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes da Venda</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body detalhes-body">
                <!-- Conteúdo carregado via AJAX -->
            </div>
            <div class="modal-footer">
                <button class="btn btn-danger btn-exportar-pdf" data-id="">
                    Exportar PDF
                </button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
@stop

@push('css')
<style>
.dataTables_wrapper {
    width: 100% !important;
    overflow-x: auto;
}
table.datatable-vendas {
    width: 100% !important;
    table-layout: auto;
}
.btn-details {
    transition: 0.3s;
}
.btn-details:hover {
    background-color: #0d6efd !important;
    border-color: #0d6efd !important;
}
</style>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" />
@endpush

@push('js')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.0/jszip.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/pdfmake/build/pdfmake.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/pdfmake/build/vfs_fonts.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function(){
    var tabela = $('.datatable-vendas').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        order: [[4, 'desc']],
        buttons: [
            { extend: 'pdf', text: 'PDF', footer: true, exportOptions: { columns: [0,1,2,3,4] } },
            { extend: 'excel', text: 'Excel', footer: true, exportOptions: { columns: [0,1,2,3,4] } },
            { extend: 'print', text: 'Imprimir', footer: true, exportOptions: { columns: [0,1,2,3,4] } }
        ],
        footerCallback: function(row, data) {
            var totalItens = this.api().column(2,{search:'applied'}).data().reduce((a,b)=>Number(a)+Number(b),0);
            var totalValor = this.api().column(3,{search:'applied'}).data().reduce((a,b)=>Number(a)+Number(b),0);
            $('#totalItens').html(totalItens);
            $('#totalValor').html(totalValor.toFixed(2)+' MT');
        },
        language: { url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/pt-PT.json" }
    });

    // Filtros por data
    $('.btn-filter').click(()=>tabela.draw());
    $('.btn-reset').click(()=>{
        $('#data_inicio,#data_fim').val('');
        tabela.draw();
    });

    $.fn.dataTable.ext.search.push(function(settings,data){
        let min=$('#data_inicio').val(), max=$('#data_fim').val(), d=data[4].split(" ")[0];
        if(!min&&!max) return true;
        if(min&&d<min) return false;
        if(max&&d>max) return false;
        return true;
    });

    $(document).on('click','.btn-details',function(){
        let codigo=$(this).data('id');
        $.get("{{ url('/vendas') }}/"+codigo,function(res){
            let html = `<strong>Código:</strong> ${res.venda.codigo}<br>
                        <strong>Usuário:</strong> ${res.venda.usuario}<br>
                        <strong>Data:</strong> ${res.venda.data}<br><br>
                        <table class="table table-bordered table-striped"><thead><tr>
                        <th>Produto</th><th>Preço</th><th>Qtd</th><th>Total</th></tr></thead><tbody>`;
            let totalGeral=0;
            res.itens.forEach(item=>{
                totalGeral+=Number(item.subtotal);
                html+=`<tr><td>${item.nome_pro}</td><td>${item.preco} MT</td>
                        <td>${item.quantidade}</td><td>${item.subtotal} MT</td></tr>`;
            });
            html+=`<tr><td colspan="3" class="text-end"><strong>Total Geral:</strong></td>
                    <td><strong>${totalGeral.toFixed(2)} MT</strong></td></tr></tbody></table>`;
            $('.detalhes-body').html(html);
            $('.btn-exportar-pdf').attr('data-id',res.venda.codigo);
            $('#detalhesModal').modal('show');
        });
    });

    $(document).on('click','.btn-exportar-pdf',function(){
        window.open("{{ url('vendas') }}/" + $(this).data('id') + "/pdf", "_blank");

    });
});
</script>
@endpush
