@extends('adminlte::page')

@section('title', 'Cadastrar Produto')

@section('content_header')
    <h1>Cadastrar Produto</h1>
@stop

@section('content')
    <form action="{{ route('produtos.store') }}" method="POST">
        @csrf

        <div class="form-group">
            <label>Código</label>
            <input type="text" name="codigo_pro" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Tipo</label>
            <input type="text" name="tipo_pro" class="form-control">
        </div>

        <div class="form-group">
            <label>Nome</label>
            <input type="text" name="nome_pro" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Preço de Venda</label>
            <input type="number" name="valor_pro" class="form-control" step="0.01" required>
        </div>

        <div class="form-group">
            <label>Preço de Compra</label>
            <input type="number" name="valor_compra" class="form-control" step="0.01" required>
        </div>

        <div class="form-group">
            <label>Quantidade</label>
            <input type="number" name="quant_pro" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Data de Cadastro</label>
            <input type="date" name="data_pro" class="form-control" required>
        </div>

        <button class="btn btn-success mt-3">Salvar</button>
        <a href="{{ route('produtos.index') }}" class="btn btn-secondary mt-3">Cancelar</a>
    </form>
@stop
