@extends('adminlte::page')

@section('title', 'Pedido #' . $pedido->id)

@section('content_header')
    <h1>Pedido #{{ $pedido->id }}</h1>
@endsection

@section('content')

<div class="card">
    <div class="card-body">
        <p><strong>Cliente:</strong> {{ $pedido->cliente_nome ?? 'Sem nome' }}</p>
        <p><strong>Criado em:</strong> {{ $pedido->created_at->format('d/m/Y H:i') }}</p>
        <hr>
        <livewire:pedido-itens :pedidoId="$pedido->id" />
    </div>
</div>

@endsection

@section('css')
<style>
.badge { font-size: 14px; }
</style>
@endsection
