@extends('adminlte::page')

@section('title', 'Gestão de Pedido')

@section('content')
<div class="container-fluid">

    <!-- Cabeçalho -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Pedido: {{ $pedido->cliente_nome }}</h2>

        <button class="btn btn-danger btn-lg" onclick="history.back()">⬅ Voltar</button>
    </div>

    <div class="row">

        <!-- PRODUTOS (lado esquerdo) -->
        <div class="col-md-7">

            <input type="text" id="search" class="form-control form-control-lg mb-2" placeholder="🔍 Procurar produto...">

            <div class="row" style="max-height:70vh; overflow-y:auto;">
                @foreach($produtos as $p)
                <div class="col-md-4 mb-3">
                    <form action="{{ route('pedidos.addItem', $pedido->id) }}" method="POST">
                        @csrf
                        <input type="hidden" name="produto_codigo" value="{{ $p->codigo_pro }}">
                        <input type="hidden" name="preco_unitario" value="{{ $p->preco_ven }}">
                        <button class="btn btn-primary w-100 p-4 produto-btn" type="submit">
                            <strong>{{ $p->nome_pro }}</strong><br>
                            <small>MZN {{ number_format($p->preco_ven,2,',','.') }}</small>
                        </button>
                    </form>
                </div>
                @endforeach
            </div>
        </div>

        <!-- ITENS DO PEDIDO -->
        <div class="col-md-5">
            <div class="card shadow">
                <div class="card-header bg-dark text-white">
                    <h4 class="mb-0">Itens do Pedido</h4>
                </div>

                <div class="card-body" style="max-height:70vh; overflow-y:auto;">
                    @foreach($pedido->itens as $item)
                        <div class="border-bottom py-2 d-flex justify-content-between align-items-center">
                            <div>
                                <strong>{{ $item->produto_codigo }}</strong>  
                                ({{ $item->quantidade_total }}x)
                                <br>
                                <span class="badge bg-success">Pago: {{ $item->quantidade_paga }}</span>
                                <span class="badge bg-warning">Pendente: {{ $item->quantidade_total - $item->quantidade_paga }}</span>
                            </div>

                            @if(($item->quantidade_total - $item->quantidade_paga) > 0)
                            <button class="btn btn-success pagar-btn" 
                                data-id="{{ $item->id }}" 
                                data-produto="{{ $item->produto_codigo }}"
                                data-preco="{{ $item->preco_unitario }}"
                                data-pendente="{{ $item->quantidade_total - $item->quantidade_paga }}">
                                💰 Pagar
                            </button>
                            @endif
                        </div>
                    @endforeach
                </div>

                <!-- Rodapé com total -->
                <div class="card-footer text-end">
                    <h3>Total Pago: 
                        <span class="text-success">
                            MZN {{ number_format($pedido->itens->sum(fn($i)=>$i->quantidade_paga*$i->preco_unitario),2,',','.') }}
                        </span>
                    </h3>

                    <h4>Pendente:
                        <span class="text-danger">
                            MZN {{ number_format($pedido->itens->sum(fn($i)=>(($i->quantidade_total-$i->quantidade_paga)*$i->preco_unitario)),2,',','.') }}
                        </span>
                    </h4>
                </div>
            </div>
        </div>
    </div>
@if($pedido->itens->sum(fn($i)=>($i->quantidade_total-$i->quantidade_paga)) == 0 && $pedido->status != 'finalizado')
    <form action="{{ route('pedido.finalizar', $pedido->id) }}" method="POST">
        @csrf
        <button class="btn btn-success btn-lg w-100 mt-3">
            ✔ FINALIZAR VENDA
        </button>
    </form>
@endif

</div>


<!-- MODAL PAGAMENTO -->
<div class="modal fade" id="modalPagamento" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" id="formPagar">
            @csrf
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">💰 Registrar Pagamento</h5>
                </div>

                <div class="modal-body">
                    <p><strong>Produto:</strong> <span id="produtoNome"></span></p>
                    <p><strong>Pendente:</strong> <span id="pendente"></span></p>

                    <label>Quantidade a Pagar:</label>
                    <input type="number" name="quantidade" id="quantidade" class="form-control" min="1" required>

                    <label class="mt-2">Método:</label>
                    <select name="metodo_pagamento" class="form-control">
                        <option>Dinheiro</option>
                        <option>Transferência</option>
                        <option>M-Pesa</option>
                        <option>Cartão</option>
                    </select>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button class="btn btn-success">Confirmar Pagamento</button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection

@section('js')
<script>
document.querySelectorAll('.pagar-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        document.getElementById('produtoNome').innerText = btn.dataset.produto;
        document.getElementById('pendente').innerText = btn.dataset.pendente;
        document.getElementById('quantidade').max = btn.dataset.pendente;

        document.getElementById('formPagar').action = "/pedido-item/" + btn.dataset.id + "/pagar";

        new bootstrap.Modal(document.getElementById('modalPagamento')).show();
    });
});
</script>
@endsection
