<div class="card">
    <div class="card-header">
        <h4>Itens do Pedido</h4>
    </div>

    <div class="card-body">

        <table class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>Produto</th>
                    <th>Qtd</th>
                    <th>Pago</th>
                    <th>Pendente</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                @foreach($itens as $item)
                    <tr class="{{ $item->quantidade == $item->quantidade_paga ? 'table-success' : '' }}">
                        <td>{{ $item->produto->nome }}</td>
                        <td>{{ $item->quantidade }}</td>
                        <td><span class="badge bg-success">{{ $item->quantidade_paga }}</span></td>
                        <td><span class="badge bg-warning">{{ $item->quantidade - ($item->quantidade_paga + $item->quantidade_cancelada) }}</span></td>
                        <td>
                            @if($item->quantidade_paga < $item->quantidade)
                                <button wire:click="pagarItem({{ $item->id }})" class="btn btn-sm btn-success">✔ Pagar</button>
                            @endif

                            @if(($item->quantidade_paga + $item->quantidade_cancelada) < $item->quantidade)
                                <button wire:click="cancelarItem({{ $item->id }})" class="btn btn-sm btn-danger">⛔ Cancelar</button>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

    </div>
</div>
