<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Histórico de Movimentos</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #ddd; }

        .entrada { color: green; font-weight: bold; }
        .saida { color: red; font-weight: bold; }
        .ajuste { color: orange; font-weight: bold; }
        .novo_produto { color: blue; font-weight: bold; }
        .atualizacao { color: darkcyan; font-weight: bold; }
        .remocao { color: darkred; font-weight: bold; }
    </style>
</head>
<body>
    <h2>📦 Histórico de Movimentações do Estoque</h2>
    <p>Gerado em: {{ now()->format('d/m/Y H:i') }}</p>

    <table>
        <thead>
            <tr>
                <th>Data</th>
                <th>Produto</th>
                <th>Tipo</th>
                <th>Quantidade</th>
                <th>Custo</th>
                <th>Referência</th>
                <th>Usuário</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($movimentos as $m)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($m->created_at)->format('d/m/Y H:i') }}</td>
                    <td>{{ $m->nome_pro }} <small>({{ $m->produto_codigo }})</small></td>
                    <td class="{{ $m->tipo }}">
                        @switch($m->tipo)
                            @case('entrada') Entrada @break
                            @case('saida') Saída @break
                            @case('ajuste') Ajuste @break
                            @case('novo_produto') Novo Produto @break
                            @case('atualizacao') Atualização @break
                            @case('remocao') Remoção @break
                            @default — @break
                        @endswitch
                    </td>
                    <td>{{ $m->quantidade }}</td>
                    <td>{{ number_format($m->custo_unitario,2,',','.') }}</td>
                    <td>{{ $m->referencia ?? '—' }}</td>
                    <td>{{ $m->usuario_nome ?? '—' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
