@extends('adminlte::page')

@section('title', 'Histórico de Movimentos')

@section('content_header')
    <h1>Histórico de Movimentação do Estoque</h1>
@stop

@section('content')

{{-- 🔍 FILTROS --}}
<form method="GET" class="row mb-4 g-2">

    <div class="col-md-3">
        <label>Produto</label>
        <input type="text" name="produto" value="{{ request('produto') }}" class="form-control rounded-input" placeholder="Nome ou Código">
    </div>

    <div class="col-md-3">
        <label>Data Início</label>
        <input type="date" name="inicio" value="{{ request('inicio') }}" class="form-control rounded-input">
    </div>

    <div class="col-md-3">
        <label>Data Fim</label>
        <input type="date" name="fim" value="{{ request('fim') }}" class="form-control rounded-input">
    </div>

    <div class="col-md-3 d-flex align-items-end gap-2">
        <button class="btn btn-primary btn-modern w-100">🔍 Filtrar</button>
        <a href="{{ route('estoque.historico') }}" class="btn btn-secondary btn-modern w-100">↺ Limpar</a>
    </div>
</form>

{{-- 📋 TABELA --}}
<div class="card shadow-sm rounded">
    <div class="card-header d-flex justify-content-between align-items-center bg-dark text-white">
        <strong>Registros</strong>
        <a href="{{ route('estoque.historico.pdf', request()->all()) }}" class="btn btn-danger btn-sm btn-modern">
            📄 Exportar PDF
        </a>
    </div>

    <div class="card-body p-0 table-responsive">
        <table class="table table-striped table-hover mb-0">
            <thead class="table-dark">
                <tr>
                    <th>Data</th>
                    <th>Produto</th>
                    <th>Tipo</th>
                    <th>Quantidade</th>
                    <th>P.Compra</th>
                    <th>Total</th>
                    <th>Referência</th>
                    <th>Usuário</th>
                </tr>
            </thead>
            <tbody>
                @forelse($movimentos as $m)
                    <tr>
                        <td>{{ date('d/m/Y H:i', strtotime($m->created_at)) }}</td>
                        <td>{{ $m->nome_pro }} <small class="text-muted">({{ $m->produto_codigo }})</small></td>

                        {{-- 🟢🔴 Badge Tipo --}}
                        <td>
                            @switch($m->tipo)
                                @case('entrada')
                                    <span class="badge bg-success">⬆ Entrada</span>
                                @break
                                @case('saida')
                                    <span class="badge bg-danger">⬇ Saída</span>
                                @break
                                @case('ajuste')
                                    <span class="badge bg-warning text-dark">⚠ Ajuste</span>
                                @break
                                @case('novo_produto')
                                    <span class="badge bg-info text-dark">🆕 Novo Produto</span>
                                @break
                                @case('atualizacao')
                                    <span class="badge bg-primary text-light">✏ Atualização</span>
                                @break
                                @case('remocao')
                                    <span class="badge bg-danger text-light">❌ Remoção</span>
                                @break
                                @default
                                    <span class="badge bg-secondary">—</span>
                            @endswitch
                        </td>

                        <td>{{ $m->quantidade }}</td>
                        <td>{{ number_format($m->custo_unitario, 2) }} MT</td>
                        <td>{{ number_format($m->quantidade * $m->custo_unitario, 2) }} MT</td>
                        <td>{{ $m->referencia ?? '—' }}</td>
                        <td>{{ $m->usuario_nome ?? '—' }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted">Nenhum registro encontrado.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        {{-- 📄 Paginação --}}
        <div class="mt-3 px-3">
            {{ $movimentos->links() }}
        </div>
    </div>
</div>

@stop

@push('css')
<style>
    /* Inputs arredondados */
    .rounded-input {
        border-radius: 8px;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    .rounded-input:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 8px rgba(59, 130, 246, 0.4);
    }

    /* Botões modernos */
    .btn-modern {
        border-radius: 8px;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    .btn-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.25);
    }

    /* Badges mais visuais */
    .badge {
        font-size: 0.85rem;
        padding: 0.35em 0.65em;
        border-radius: 6px;
    }

    /* Card da tabela */
    .card.shadow-sm {
        border-radius: 10px;
        overflow: hidden;
    }

    /* Linha da tabela com hover */
    table.table-striped tbody tr:hover {
        background-color: #f1f5f9;
    }

    @media (max-width:576px){
        .table-responsive { overflow-x:auto; }
    }
</style>
@endpush
