<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Histórico de Entradas de Estoque</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #ddd; }

        .entrada { color: green; font-weight: bold; }
    </style>
</head>
<body>
    <h2> Histórico de Entradas de Estoque</h2>
    <p>Gerado em: {{ now()->format('d/m/Y H:i') }}</p>

    <table>
        <thead>
            <tr>
                <th>Data</th>
                <th>Produto</th>
                <th>Quantidade</th>
                <th>Preço Unitário</th>
                <th>Usuário</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($entradas as $e)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($e->data)->format('d/m/Y H:i') }}</td>
                    <td>{{ $e->nome_pro }} <small>({{ $e->produto_codigo ?? '' }})</small></td>
                    <td class="entrada">{{ $e->quantidade }}</td>
                    <td>{{ number_format($e->preco_unitario, 2, ',', '.') }} MT</td>
                    <td>{{ $e->usuario ?? 'Sistema' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
