<!doctype html>
<html>
<head>
<meta charset="utf-8"/>
<title>Relatório Dashboard</title>
<style>
body { font-family: DejaVu Sans, sans-serif; font-size:12px; }
h2 { text-align:center; }
.table { width:100%; border-collapse: collapse; margin-top:10px; }
.table th, .table td { border:1px solid #000; padding:6px; }
</style>
</head>
<body>
    <h2>Relatório Consolidado</h2>
    <p>Filtros: {{ json_encode($request) }}</p>

    <h3>Resumo</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Local</th>
                <th>Total Vendido (MT)</th>
                <th>Total Lucro (MT)</th>
                <th>Qtd Estoque</th>
                <th>Valor Estoque (MT)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>BAR</td>
                <td>{{ number_format($barTotalVendido,2,',','.') }}</td>
                <td>{{ number_format($barLucro,2,',','.') }}</td>
                <td>{{ number_format($barEstoqueQtd) }}</td>
                <td>{{ number_format($barEstoqueValor,2,',','.') }}</td>
            </tr>
            <tr>
                <td>ARM</td>
                <td>{{ number_format($armTotalVendido,2,',','.') }}</td>
                <td>{{ number_format($armLucro,2,',','.') }}</td>
                <td>{{ number_format($armEstoqueQtd) }}</td>
                <td>{{ number_format($armEstoqueValor,2,',','.') }}</td>
            </tr>
            <tr>
                <td><strong>Total</strong></td>
                <td><strong>{{ number_format($barTotalVendido + $armTotalVendido,2,',','.') }}</strong></td>
                <td><strong>{{ number_format($barLucro + $armLucro,2,',','.') }}</strong></td>
                <td><strong>{{ number_format($barEstoqueQtd + $armEstoqueQtd) }}</strong></td>
                <td><strong>{{ number_format($barEstoqueValor + $armEstoqueValor,2,',','.') }}</strong></td>
            </tr>
        </tbody>
    </table>

    <h3>Top Produtos</h3>
    <table class="table">
        <thead>
            <tr><th>Produto</th><th>Quantidade</th><th>Subtotal (MT)</th></tr>
        </thead>
        <tbody>
            @foreach($vendas->groupBy('codigo_pro') as $codigo => $group)
                @php
                    $q = $group->sum('quantidade');
                    $s = $group->reduce(fn($c,$i)=> $c + ($i->preco * $i->quantidade), 0);
                    $nome = $group->first()->nome_pro ?? $codigo;
                @endphp
                <tr>
                    <td>{{ $nome }} ({{ $codigo }})</td>
                    <td>{{ $q }}</td>
                    <td>{{ number_format($s,2,',','.') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
