@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
<h1 class="mb-4">Dashboard do Sistema</h1>
@stop

@section('content')
<style>
    /* Cards modernos */
    .card-modern {
        border-radius: 15px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .card-modern:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.12);
    }

    /* Botões modernos */
    .btn-modern {
        border-radius: 8px;
        padding: 0.5rem 1.2rem;
        font-weight: 600;
        transition: all 0.2s;
    }
    .btn-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }

    /* Inputs modernos */
    .form-control-modern {
        border-radius: 8px;
        border: 1px solid #d1d5db;
        padding: 0.5rem 1rem;
        transition: all 0.3s;
    }
    .form-control-modern:focus {
        outline: none;
        border-color: #0d6efd;
        box-shadow: 0 0 8px rgba(13,110,253,0.2);
    }

    /* Gráficos responsivos */
    .chart-container {
        position: relative;
        height: 300px;
    }

    /* Listas de estoque crítico */
    .list-group-item {
        border-radius: 8px;
        margin-bottom: 5px;
    }
</style>

<div class="container-fluid">

    <!-- Filtros -->
    <form method="GET" action="{{ route('dashboard') }}" class="row mb-4 g-2">
        <div class="col-12 col-md-2">
            <input type="date" name="start" class="form-control-modern w-100" value="{{ request('start') }}">
        </div>
        <div class="col-12 col-md-2">
            <input type="date" name="end" class="form-control-modern w-100" value="{{ request('end') }}">
        </div>
        <div class="col-12 col-md-2">
            <select name="categoria" class="form-control-modern w-100">
                <option value="todas" {{ request('categoria')=='todas'?'selected':'' }}>Todos os Setores</option>
                <option value="BAR" {{ request('categoria')=='BAR'?'selected':'' }}>BAR</option>
                <option value="ARM" {{ request('categoria')=='ARM'?'selected':'' }}>ARM</option>
            </select>
        </div>
        <div class="col-12 col-md-2">
            <select name="produto" class="form-control-modern w-100">
                <option value="todos">Todos os Produtos</option>
                @foreach($produtosFiltro as $p)
                <option value="{{ $p->codigo_pro }}" {{ request('produto')==$p->codigo_pro?'selected':'' }}>
                    {{ $p->nome_pro }}
                </option>
                @endforeach
            </select>
        </div>
        <div class="col-12 col-md-2">
            <input type="number" name="estoque_critico" class="form-control-modern w-100" value="{{ request('estoque_critico', 5) }}" min="1" title="Estoque crítico (<=)">
        </div>
        <div class="col-12 col-md-2 d-grid">
            <button type="submit" class="btn btn-primary btn-modern w-100">Aplicar</button>
        </div>

        <div class="col-12 mt-2 d-flex justify-content-end gap-2">
            <a href="{{ route('dashboard.export.pdf', request()->all()) }}" target="_blank" class="btn btn-danger btn-modern">📄 PDF</a>
            <a href="{{ route('dashboard.export.excel', request()->all()) }}" class="btn btn-success btn-modern">📎 Excel</a>
        </div>
    </form>

    <!-- CARDS PRINCIPAIS -->
    <div class="row g-3 mb-4">
        <!-- BAR -->
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-info text-white">
                <h6>Vendido (BAR)</h6>
                <h3 class="fw-bold">{{ number_format($barTotalVendido,2,',','.') }} MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-success text-white">
                <h6>Lucro (BAR)</h6>
                <h3 class="fw-bold">{{ number_format($barLucro,2,',','.') }} MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-primary text-white">
                <h6>Qtd Estoque (BAR)</h6>
                <h3 class="fw-bold">{{ $barEstoqueQtd }}</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-warning text-dark">
                <h6>Valor Estoque (BAR)</h6>
                <h3 class="fw-bold">{{ number_format($barEstoqueValor,2,',','.') }} MT</h3>
            </div>
        </div>
    </div>

    <!-- ARM -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-info text-white">
                <h6>Vendido (ARM)</h6>
                <h3 class="fw-bold">{{ number_format($armTotalVendido,2,',','.') }} MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-success text-white">
                <h6>Lucro (ARM)</h6>
                <h3 class="fw-bold">{{ number_format($armLucro,2,',','.') }} MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-primary text-white">
                <h6>Qtd Estoque (ARM)</h6>
                <h3 class="fw-bold">{{ $armEstoqueQtd }}</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-warning text-dark">
                <h6>Valor Estoque (ARM)</h6>
                <h3 class="fw-bold">{{ number_format($armEstoqueValor,2,',','.') }} MT</h3>
            </div>
        </div>
    </div>

    <!-- TOTAL GERAL -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-info text-white">
                <h6>Total Vendido</h6>
                <h3 class="fw-bold">{{ number_format($totalVendas,2,',','.') }} MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-success text-white">
                <h6>Total Lucro</h6>
                <h3 class="fw-bold">{{ number_format($totalLucro,2,',','.') }} MT</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-primary text-white">
                <h6>Qtd Estoque Total</h6>
                <h3 class="fw-bold">{{ $totalEstoqueQtd }}</h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card-modern p-3 text-center bg-warning text-dark">
                <h6>Valor Estoque Total</h6>
                <h3 class="fw-bold">{{ number_format($totalEstoqueValor,2,',','.') }} MT</h3>
            </div>
        </div>
    </div>

    <!-- GRÁFICOS -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">📈 Vendas Mensais</h5>
                <div class="chart-container">
                    <canvas id="chartVendas"></canvas>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">💰 Lucro Mensal</h5>
                <div class="chart-container">
                    <canvas id="chartLucro"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- PRODUTOS MAIS VENDIDOS E ESTOQUE CRÍTICO -->
    <div class="row g-3">
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">🔥 Produtos Mais Vendidos</h5>
                <div class="chart-container">
                    <canvas id="chartProdutos"></canvas>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="card-modern p-3 bg-white">
                <h5 class="fw-semibold text-center mb-3">🚨 Estoque Crítico</h5>

                <h6>BAR</h6>
                <ul class="list-group mb-2">
                    @forelse($criticosBar as $item)
                        <li class="list-group-item d-flex justify-content-between">
                            {{ $item->nome_pro }} <span class="badge bg-danger rounded-pill">{{ $item->quant_pro }}</span>
                        </li>
                    @empty
                        <li class="list-group-item text-center text-muted">Nenhum produto crítico em BAR</li>
                    @endforelse
                </ul>

                <h6>ARM</h6>
                <ul class="list-group">
                    @forelse($criticosArm as $item)
                        <li class="list-group-item d-flex justify-content-between">
                            {{ $item->nome_pro }} <span class="badge bg-danger rounded-pill">{{ $item->quant_pro }}</span>
                        </li>
                    @empty
                        <li class="list-group-item text-center text-muted">Nenhum produto crítico em ARM</li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>

</div>
@stop

@push('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const options = { responsive: true, plugins: { legend: { position: 'bottom' } } };

// Gráfico Vendas
new Chart(document.getElementById('chartVendas'), {
    type: 'line',
    data: {
        labels: {!! json_encode($vendasMensais->pluck('mes')) !!},
        datasets: [{
            label: "Vendas (MT)",
            data: {!! json_encode($vendasMensais->pluck('total')) !!},
            borderColor: "#0d6efd",
            backgroundColor: "rgba(13,110,253,0.1)",
            tension: 0.4,
            fill: true,
            pointRadius: 5
        }]
    },
    options: options
});

// Gráfico Lucro
new Chart(document.getElementById('chartLucro'), {
    type: 'bar',
    data: {
        labels: {!! json_encode($lucroMensal->pluck('mes')) !!},
        datasets: [{
            label: "Lucro (MT)",
            data: {!! json_encode($lucroMensal->pluck('lucro')) !!},
            backgroundColor: "#198754",
            borderRadius: 5
        }]
    },
    options: options
});

// Gráfico Produtos Mais Vendidos
new Chart(document.getElementById('chartProdutos'), {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($maisVendidos->pluck('nome_pro')) !!},
        datasets: [{
            data: {!! json_encode($maisVendidos->pluck('quant')) !!},
            backgroundColor: ["#0d6efd","#198754","#ffc107","#dc3545"]
        }]
    },
    options: options
});
</script>
@endpush
