<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        /**
         * FILTRAR MENU DO ADMINLTE BASEADO NO PAPEL DO USUÁRIO
         *
         * - ADMIN vê tudo
         * - NORMAL vê apenas onde role = NORMAL
         * - Itens sem role só aparecem para visitantes (não logados)
         */
        View::composer('*', function () {

            $menu = config('adminlte.menu', []);
            $user = Auth::user();

            // Se o usuário NÃO estiver logado → mostrar apenas itens sem "role"
            if (!$user) {
                $filtered = array_filter($menu, function ($item) {
                    return !isset($item['role']);
                });

                config(['adminlte.menu' => array_values($filtered)]);
                return;
            }

            // Usuário logado → filtrar conforme tipo_us
            $userRole = Str::upper($user->tipo_us);   // ADMIN ou NORMAL

            $filtered = array_filter($menu, function ($item) use ($userRole) {

                // Itens sem "role" não devem aparecer para logados
                if (!isset($item['role'])) {
                    return false;
                }

                // Se o role for array → permitir se estiver lá
                if (is_array($item['role'])) {
                    $roles = array_map(fn($r) => Str::upper($r), $item['role']);
                    return in_array($userRole, $roles);
                }

                // Role string simples
                return Str::upper($item['role']) === $userRole;
            });

            config(['adminlte.menu' => array_values($filtered)]);
        });
    }
}
