<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;

class Usuario extends Authenticatable
{
    use Notifiable;

    // Se a PK não é auto-increment
    protected $primaryKey = 'codigo_us';
    public $incrementing = false;
    protected $keyType = 'string';

    // Campos permitidos para preenchimento em massa
    protected $fillable = [
        'codigo_us',
        'nome_us',
        'sexo_us',
        'tipo_us',
        'senha',
        'acesso_us',
    ];

    // Campos ocultos em arrays/JSON
    protected $hidden = [
        'senha',
    ];

    /**
     * Laravel espera o método getAuthPassword() para pegar a senha
     */
    public function getAuthPassword()
    {
        return $this->senha;
    }

    /**
     * Sobrescrever o setter da senha para hash automático
     */
    public function setSenhaAttribute($value)
    {
        $this->attributes['senha'] = Hash::make($value);
    }

    /**
     * Verifica se o usuário é ADMIN
     */
    public function isAdmin()
    {
        return $this->tipo_us === 'ADMIN';
    }
}
