<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PedidoItem extends Model
{
    protected $table = 'pedido_itens';
    protected $fillable = [
        'pedido_id',
        'produto_codigo',
        'quantidade_total',
        'quantidade_paga',
        'preco_unitario'
    ];

    public function pedido()
    {
        return $this->belongsTo(Pedido::class);
    }

    public function pagamentos()
    {
        return $this->hasMany(PedidoPagamento::class, 'pedido_item_id');
    }
}
