<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Pedido;
use App\Models\PedidoItem;

class PedidoItens extends Component
{
    public $pedido;
    public $itens;

    public function mount($pedidoId)
    {
        $this->pedido = Pedido::find($pedidoId);
        $this->loadItens();
    }

    public function loadItens()
    {
        $this->itens = PedidoItem::where('pedido_id', $this->pedido->id)->with('produto')->get();
    }

    public function pagarItem($itemId)
    {
        $item = PedidoItem::findOrFail($itemId);

        if ($item->quantidade_paga < $item->quantidade) {
            $item->quantidade_paga += 1;
            $item->save();
        }

        $this->loadItens();
    }

    public function cancelarItem($itemId)
    {
        $item = PedidoItem::findOrFail($itemId);

        if ($item->quantidade_cancelada < $item->quantidade) {
            $item->quantidade_cancelada += 1;
            $item->save();
        }

        $this->loadItens();
    }

    public function render()
    {
        return view('livewire.pedido-itens');
    }
}
