<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RoleMiddleware
{
    public function handle(Request $request, Closure $next, string $role)
    {
        $user = Auth::user();

        if (! $user) {
            return redirect()->route('login');
        }
if (strtoupper(trim($user->tipo_us)) !== strtoupper(trim($role))) {
    abort(403);
}

        // if (($user->tipo_us ?? '') !== $role) {
        //     abort(403);
        // }

        return $next($request);
    }
}
