<?php

namespace App\Http\Controllers;

use App\Models\Pedido;
use App\Models\PedidoItem;
use App\Models\PedidoPagamento;
use Illuminate\Http\Request;

class PedidoController extends Controller
{
    public function index()
    {
        $pedidos = Pedido::with('itens')->orderBy('id', 'DESC')->get();
        return view('pedidos.index', compact('pedidos'));
    }



    public function create()
    {
        return view('pedidos.create');
    }

    public function store(Request $request)
    {
        $pedido = Pedido::create([
            'cliente_nome' => $request->cliente_nome
        ]);

        return redirect()->route('pedidos.edit', $pedido->id);
    }

    public function edit($id)
    {
        $pedido = Pedido::with('itens')->findOrFail($id);
        return view('pedidos.edit', compact('pedido'));
    }

    public function adicionarItem(Request $request, $id)
    {
        PedidoItem::create([
            'pedido_id' => $id,
            'produto_codigo' => $request->produto_codigo,
            'quantidade_total' => $request->quantidade,
            'preco_unitario' => $request->preco_unitario
        ]);

        return back();
    }

    public function pagarItem(Request $request, PedidoItem $item)
    {
        $item->quantidade_paga += $request->quantidade;
        $item->save();

        PedidoPagamento::create([
            'pedido_item_id' => $item->id,
            'quantidade_paga' => $request->quantidade,
            'valor' => $request->quantidade * $item->preco_unitario
        ]);

        return back();
    }
    public function finalizar($id)
{
    $pedido = Pedido::with('itens')->findOrFail($id);

    // Verifica se ainda há pendências
    $pendente = $pedido->itens->sum(function ($item) {
        return ($item->quantidade_total - $item->quantidade_paga);
    });

    if ($pendente > 0) {
        return back()->with('error', 'Ainda existem itens pendentes. Não pode finalizar.');
    }

    // Criar registro de venda final
    $totalVenda = $pedido->itens->sum(function ($item) {
        return $item->quantidade_paga * $item->preco_unitario;
    });

    // Inserir na tabela vendas
    $codigoVenda = 'PED-' . str_pad($pedido->id, 5, '0', STR_PAD_LEFT);

    \DB::table('vendas')->insert([
        'codigoVenda' => $codigoVenda,
        'dataVenda' => now(),
        'valorTotal' => $totalVenda,
        'estadoVenda' => 'Finalizado'
    ]);

    // Registrar cada item na tabela itensvenda
    foreach ($pedido->itens as $item) {
        \DB::table('itensvenda')->insert([
            'codigoVenda' => $codigoVenda,
            'codProduto' => $item->produto_codigo,
            'preco' => $item->preco_unitario,
            'quantidade' => $item->quantidade_paga,
            'subtotal' => $item->preco_unitario * $item->quantidade_paga
        ]);
    }

    // Atualizar status do pedido
    $pedido->update(['status' => 'finalizado']);

    return redirect()->route('pedidos.index')->with('success', 'Pedido finalizado com sucesso.');
}
public function show($id)
{
    $pedido = Pedido::with('itens.produto')->findOrFail($id);

    return view('pedidos.show', compact('pedido'));
}


}
